/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.danmaku;

import dev.xkmc.fastprojectileapi.entity.GrazingEntity;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.youkaishomecoming.content.capability.GrazeCapability;
import dev.xkmc.youkaishomecoming.content.capability.GrazeHelper;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.events.GeneralEventHandlers;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public interface IYHDanmaku
extends GrazingEntity {
    public static final float GRAZE_RANGE = 1.5f;

    public float damage(Entity var1);

    public SimplifiedProjectile self();

    @Override
    default public float grazeRange() {
        return 1.5f;
    }

    @Override
    default public AABB alterHitBox(Entity x, float radius, float graze) {
        Entity entity = this.self().m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (x instanceof YoukaiEntity) {
                YoukaiEntity youkai = (YoukaiEntity)x;
                if (youkai.targets.contains((LivingEntity)player)) {
                    return youkai.m_20191_().m_82400_(1.5);
                }
            }
        }
        return IYHDanmaku.alterEntityHitBox(x, radius, graze);
    }

    default public boolean shouldHurt(@Nullable Entity owner, Entity e) {
        if (owner == null) {
            return false;
        }
        if (owner instanceof YoukaiEntity) {
            YoukaiEntity youkai = (YoukaiEntity)owner;
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                return youkai.shouldHurt(le);
            }
            return false;
        }
        return true;
    }

    default public DamageSource source() {
        DamageSource dmgType = YHDamageTypes.danmaku(this);
        Entity entity = this.self().m_19749_();
        if (entity instanceof CardHolder) {
            CardHolder youkai = (CardHolder)entity;
            dmgType = youkai.getDanmakuDamageSource(this);
        }
        if ((entity = this.self().m_19749_()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            dmgType = GeneralEventHandlers.modifyDamageType(le, dmgType, this);
        }
        return dmgType;
    }

    default public void hurtTarget(EntityHitResult result) {
        if (this.self().m_9236_().f_46443_) {
            return;
        }
        Entity e = result.m_82443_();
        DamageSource source = this.source();
        if (e instanceof LivingEntity) {
            DamageSource last;
            LivingEntity le = (LivingEntity)e;
            if (le.f_20916_ > 0 && (((Boolean)YHModConfig.COMMON.invulFrameForDanmaku.get()).booleanValue() || e instanceof Player || e instanceof YoukaiEntity) && (last = le.m_21225_()) != null && last.m_7640_() instanceof IYHDanmaku) {
                return;
            }
        }
        LivingEntity target = null;
        while (e instanceof PartEntity) {
            PartEntity pe = (PartEntity)e;
            e = pe.getParent();
        }
        if (e instanceof LivingEntity) {
            LivingEntity le;
            target = le = (LivingEntity)e;
        }
        Entity owner = this.self().m_19749_();
        if (target != null && owner instanceof YoukaiEntity) {
            YoukaiEntity youkai = (YoukaiEntity)owner;
            youkai.danmakuHitTarget(this, source, target);
            return;
        }
        if (owner instanceof Player) {
            Player player = (Player)owner;
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                if (!((GrazeCapability)GrazeCapability.HOLDER.get(player)).shouldHurt(le)) {
                    return;
                }
            }
        }
        e.m_6469_(source, this.damage(e));
    }

    public static AABB alterEntityHitBox(Entity x, float radius, float graze) {
        float f;
        AABB box = x.m_20191_();
        if (graze > 0.0f) {
            return box.m_82400_((double)(radius + graze));
        }
        if (x instanceof Player) {
            Player player = (Player)x;
            f = GrazeHelper.getHitBoxShrink(player);
        } else {
            f = 0.0f;
        }
        float shrink = f;
        return new AABB(box.f_82288_ + (double)shrink - (double)radius, box.f_82289_ + (double)(shrink * 2.0f) - (double)radius, box.f_82290_ + (double)shrink - (double)radius, box.f_82291_ - (double)shrink + (double)radius, box.f_82292_ + (double)radius, box.f_82293_ - (double)shrink + (double)radius);
    }
}

